EasierEngineStarting = {
	specEntryName = string.format("spec_%s.easierEngineStarting", g_currentModName)
}

function EasierEngineStarting.prerequisitesPresent(specializations)
	return true
end

function EasierEngineStarting.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", EasierEngineStarting)
end

function EasierEngineStarting:onLoad(savegame)
	self.addPoweredActionEvent = Utils.overwrittenFunction(self.addPoweredActionEvent, function (object, superFunc, actionEventsTable, inputAction, target, callback, triggerUp, triggerDown, triggerAlways, startActive, callbackState, customIconName, ignoreCollisions, reportAnyDeviceCollision)
		local function newCallback(vehicle, actionName, inputValue, state, isAnalog, isMouse, deviceCategory, binding)
			local isPowered, warning = vehicle:getIsPowered()

			if isPowered then
				callback(vehicle, actionName, inputValue, state, isAnalog, isMouse, deviceCategory, binding)
			elseif inputValue ~= 0 and warning ~= nil then
				if actionEventsTable == object.spec_drivable.actionEvents and inputAction == InputAction.AXIS_ACCELERATE_VEHICLE and g_additionalSettingsManager:getSettingStateByName("easyMotorStart") and not g_currentMission.missionInfo.automaticMotorStartEnabled then
					if not object:getIsAIActive() and not object:getIsMotorStarted() and object:getCanMotorRun() then
						object:startMotor()
					end
				else
					g_currentMission:showBlinkingWarning(warning, 2000)
				end
			end
		end

		return object:addActionEvent(actionEventsTable, inputAction, target, newCallback, triggerUp, triggerDown, triggerAlways, startActive, callbackState, customIconName, ignoreCollisions, reportAnyDeviceCollision)
	end)
end