--
-- main
--
-- @author Rockstar
-- @date 27/03/2021
--

--
-- @fs22 24/11/2021
--


local function init(modDir, modSettingsDir,  modName)
	g_env = getmetatable(_G).__index

	Mission00.setMissionInfo = Utils.prependedFunction(Mission00.setMissionInfo, function (object, missionInfo, missionDynamicInfo)
		g_env.g_additionalSettingsManager = AdditionalSettingsManager.new(modDir, modSettingsDir, modName)
	end)

	TypeManager.finalizeTypes = Utils.prependedFunction(TypeManager.finalizeTypes, function (object)
		if object.typeName == "vehicle" then
			for typeName, typeEntry in pairs(object:getTypes()) do
				if SpecializationUtil.hasSpecialization(Drivable, typeEntry.specializations) then
					object:addSpecialization(typeName, modName .. ".easierEngineStarting")
				end

				if SpecializationUtil.hasSpecialization(Trailer, typeEntry.specializations) or typeName == "manureSpreader" then
					object:addSpecialization(typeName, modName .. ".trailerHUD")
				end
			end
		end
	end)

	g_env.draw = Utils.prependedFunction(g_env.draw, function ()
		if g_additionalSettingsManager ~= nil and g_additionalSettingsManager.preDraw ~= nil then
			g_additionalSettingsManager:preDraw()
		end
	end)
end

init(g_currentModDirectory, g_currentModSettingsDirectory, g_currentModName)