--
-- AdditionalSettingsFrame
--
-- @author Rockstar
-- @date 27/03/2021
--

--
-- @fs22 24/11/2021
--


AdditionalSettingsFrame = {
	CONTROLS = {
		SETTINGS_CONTAINER = "settingsContainer",
		BOX_LAYOUT = "boxLayout",
		CHECKBOX_HUD = "checkHUD",
		OPTION_CROSSHAIR = "multiCrosshair",
		OPTION_DATE = "multiDate",
		OPTION_CLOCK_POSITION = "multiClockPosition",
		CHECKBOX_HOUR_FORMAT = "checkHourFormat",
		OPTION_FADE_EFFECT = "multiFadeEffect",
		CHECK_DIALOG_BOXES = "checkDialogBoxes",
		OPTION_TRAILER_HUD = "multiTrailerHUD",
		OPTION_VEHICLE_CAMERA = "multiVehicleCamera",
		OPTION_PLAYER_CAMERA = "multiPlayerCamera",
		CHECK_EASY_MOTOR_START = "checkEasyMotorStart",
		CHECK_AUTOSTART = "checkAutostart",
		OPTION_STORE_ITEMS = "mulitStoreItems",
		OPTION_LIGHTING = "multiLighting",
		CHECK_DOF = "checkDoF",
		CHECK_WILD_ANIMALS = "checkWildAnimals",
		CHECK_CAMERA_COLLISIONS = "checkCameraCollisions",
		CHECK_GUI_CAMERA = "checkGuiCamera",
		OPTION_FRAMERATE_LIMITER = "mulitFramerateLimiter",
		BUTTON_DATE_COLOR = "buttonDateColor",
		CHECK_CLOCK_BACKGROUND = "checkClockBackground",
		CHECK_BLINKING_WARNINGS = "checkBlinkingWarnings",
	}
}

local AdditionalSettingsFrame_mt = Class(AdditionalSettingsFrame, TabbedMenuFrameElement)

function AdditionalSettingsFrame.new(subclass_mt)
	local self = TabbedMenuFrameElement.new(nil, subclass_mt or AdditionalSettingsFrame_mt)

	self:registerControls(AdditionalSettingsFrame.CONTROLS)

	self.isDirty = false

	self.checkboxMapping = {}
	self.optionMapping = {}
	self.buttonMapping = {}

	return self
end

function AdditionalSettingsFrame:getMainElementSize()
	return self.settingsContainer.size
end

function AdditionalSettingsFrame:getMainElementPosition()
	return self.settingsContainer.absPosition
end

function AdditionalSettingsFrame:onFrameOpen(element)
	AdditionalSettingsFrame:superClass().onFrameOpen(self)

	self:updateAdditionalSettings()
	self.isDirty = false

	self.boxLayout:invalidateLayout()

	if FocusManager:getFocusedElement() == nil then
		self:setSoundSuppressed(true)
		FocusManager:setFocus(self.boxLayout)
		self:setSoundSuppressed(false)
	end
end

function AdditionalSettingsFrame:onFrameClose()
	AdditionalSettingsFrame:superClass().onFrameClose(self)

	if self.isDirty then
		self.settingsManager:saveSettingsToXMLFile()
		self.isDirty = false
	end
end

function AdditionalSettingsFrame:initialize(settingsManager)
	local addittionalSettings = settingsManager.addittionalSettings

	self.checkboxMapping[self.checkHUD] = addittionalSettings.hud
	self.checkboxMapping[self.checkHourFormat] = addittionalSettings.hourFormat
	self.checkboxMapping[self.checkDialogBoxes] = addittionalSettings.dialogBoxes
	self.checkboxMapping[self.checkEasyMotorStart] = addittionalSettings.easyMotorStart
	self.checkboxMapping[self.checkAutostart] = addittionalSettings.autostart
	self.checkboxMapping[self.checkDoF] = addittionalSettings.dof
	self.checkboxMapping[self.checkWildAnimals] = addittionalSettings.wildAnimals
	self.checkboxMapping[self.checkCameraCollisions] = addittionalSettings.cameraCollisions
	self.checkboxMapping[self.checkGuiCamera] = addittionalSettings.guiCamera
	self.checkboxMapping[self.checkClockBackground] = addittionalSettings.clockBackground
	self.checkboxMapping[self.checkBlinkingWarnings] = addittionalSettings.blinkingWarnings

	self.optionMapping[self.multiCrosshair] = addittionalSettings.crosshair
	self.optionMapping[self.multiDate] = addittionalSettings.date
	self.optionMapping[self.multiClockPosition] = addittionalSettings.clockPosition
	self.optionMapping[self.multiFadeEffect] = addittionalSettings.fadeEffect
	self.optionMapping[self.multiVehicleCamera] = addittionalSettings.vehicleCamera
	self.optionMapping[self.multiPlayerCamera] = addittionalSettings.playerCamera
	self.optionMapping[self.mulitStoreItems] = addittionalSettings.storeItems
	self.optionMapping[self.multiLighting] = addittionalSettings.lighting
	self.optionMapping[self.mulitFramerateLimiter] = addittionalSettings.framerateLimiter
	self.optionMapping[self.multiTrailerHUD] = addittionalSettings.trailerHUD

	self.buttonMapping[self.buttonDateColor] = addittionalSettings.clockColor

	for checkboxElement, settingsKey in pairs(self.checkboxMapping) do
		AdditionalSettingsUtil.callFunction(settingsKey, "onCreateElement", checkboxElement)
	end

	for optionElement, settingsKey in pairs(self.optionMapping) do
		AdditionalSettingsUtil.callFunction(settingsKey, "onCreateElement", optionElement)
	end

	for buttonElement, settingsKey in pairs(self.buttonMapping) do
		AdditionalSettingsUtil.callFunction(settingsKey, "onCreateElement", buttonElement)
	end

	self.settingsManager = settingsManager
end

function AdditionalSettingsFrame:updateAdditionalSettings()
	for checkboxElement, settingsKey in pairs(self.checkboxMapping) do
		AdditionalSettingsUtil.callFunction(settingsKey, "onFrameOpen", checkboxElement)
		checkboxElement:setIsChecked(settingsKey.active)
	end

	for optionElement, settingsKey in pairs(self.optionMapping) do
		AdditionalSettingsUtil.callFunction(settingsKey, "onFrameOpen", optionElement)
		optionElement:setState(settingsKey.state + 1)
	end

	for buttonElement, settingsKey in pairs(self.buttonMapping) do
		AdditionalSettingsUtil.callFunction(settingsKey, "onFrameOpen", buttonElement)
	end
end

function AdditionalSettingsFrame:onClickCheckbox(state, checkboxElement)
	local checkboxMapping = self.checkboxMapping[checkboxElement]

	if checkboxMapping ~= nil then
		local newState = state == CheckedOptionElement.STATE_CHECKED

		checkboxMapping.active = newState

		AdditionalSettingsUtil.callFunction(checkboxMapping, "onStateChange", newState, checkboxElement, false)
		self.isDirty = true
	else
		print("Warning: Invalid settings checkbox event or key configuration for element " .. checkboxElement:toString())
	end
end

function AdditionalSettingsFrame:onClickMultiOption(state, optionElement)
	local optionMapping = self.optionMapping[optionElement]

	if optionMapping ~= nil then
		local newState = state - 1

		optionMapping.state = newState

		AdditionalSettingsUtil.callFunction(optionMapping, "onStateChange", newState, optionElement, false)
		self.isDirty = true
	else
		print("Warning: Invalid settings multi option event or key configuration for element " .. optionElement:toString())
	end
end

function AdditionalSettingsFrame:onClickButton(buttonElement)
	local buttonMapping = self.buttonMapping[buttonElement]

	if buttonMapping ~= nil then
		AdditionalSettingsUtil.callFunction(buttonMapping, "onClickButton", buttonElement)
		self.isDirty = true
	else
		print("Warning: Invalid settings button event or key configuration for element " .. buttonElement:toString())
	end
end