--
-- AdditionalSettingsUtil
--
-- @author Rockstar
-- @date 27/03/2021
--

--
--	@fs22 24/11/2021
--


AdditionalSettingsUtil = {
	eventListeners = {}
}

function AdditionalSettingsUtil.registerEvent(eventName)
	AdditionalSettingsUtil.eventListeners[eventName] = {}
end

function AdditionalSettingsUtil.registerEventListener(eventName, object)
	table.insert(AdditionalSettingsUtil.eventListeners[eventName], object)
end

function AdditionalSettingsUtil.raiseEvent(eventName, ...)
	for _, object in pairs(AdditionalSettingsUtil.eventListeners[eventName]) do
		object[eventName](object, ...)
	end
end

function AdditionalSettingsUtil.prependedFunction(oldTarget, oldFunc, newTarget, newFunc, allow)
	if allow or allow == nil then
		oldTarget[oldFunc] = Utils.prependedFunction(oldTarget[oldFunc], function (...)
			newTarget[newFunc](newTarget, ...)
		end)
	end
end

function AdditionalSettingsUtil.appendedFunction(oldTarget, oldFunc, newTarget, newFunc, allow)
	if allow or allow == nil then
		oldTarget[oldFunc] = Utils.appendedFunction(oldTarget[oldFunc], function (...)
			newTarget[newFunc](newTarget, ...)
		end)
	end
end

function AdditionalSettingsUtil.overwrittenFunction(oldTarget, oldFunc, newTarget, newFunc, allow)
	if allow or allow == nil then
		oldTarget[oldFunc] = Utils.overwrittenFunction(oldTarget[oldFunc], function (...)
			return newTarget[newFunc](newTarget, ...)
		end)
	end
end

function AdditionalSettingsUtil.overwrittenStaticFunction(oldTarget, oldFunc, newTarget, newFunc, allow)
	if allow or allow == nil then
		local func = oldTarget[oldFunc]

		oldTarget[oldFunc] = function(...)
			return newTarget[newFunc](newTarget, func, ...)
		end
	end
end

function AdditionalSettingsUtil.callFunction(object, funcName, ...)
	local func = object[funcName]

	if func ~= nil then
		return func(object, ...)
	end
end

function AdditionalSettingsUtil.copyFiles(directory, targetDirectory, filenames, force)
	for _, filename in pairs(filenames) do
		copyFile(directory .. filename, targetDirectory .. filename, force or false)
	end
end

function AdditionalSettingsUtil.info(infoMessage, ...)
	print(string.format("AdditionalGameSettings Info: " .. infoMessage, ...))
end

function AdditionalSettingsUtil.error(errorMessage, ...)
	printError(string.format("AdditionalGameSettings Error: " .. errorMessage, ...))
end

function AdditionalSettingsUtil.warning(warningMessage, ...)
	printWarning(string.format("AdditionalSettingsUtil Warning: " .. warningMessage, ...))
end