RoundbaleFillVolume = {}

function Bale:setNodeId(nodeId)
    Bale:superClass().setNodeId(self, nodeId);
    local isRoundbale = Utils.getNoNil(getUserAttribute(nodeId, "isRoundbale"), false);
    local defaultFillLevel = 4000;  -- Diesen Wert abändern auf das BallenVolume euerer Rundballenpresse --
    if getUserAttribute(nodeId, "baleValue") ~= nil then
        print("Warning: bale 'baleValue' is not supported anymore. Use 'baleValueScale' instead and adjust the creating vehicles.");
    end
    local meshIndex = Utils.getNoNil(getUserAttribute(nodeId, "baleMeshIndex"), "1|0");
    self.meshNode = I3DUtil.indexToObject(nodeId, meshIndex);
    self.meshNodes = {self.meshNode}
    self.supportsWrapping = Utils.getNoNil(getUserAttribute(nodeId, "supportsWrapping"), false);
    if self.supportsWrapping then
        self.wrappingColor = {1,1,1,1};
    end
    self.fillLevel = defaultFillLevel
    self.baleValueScale = Utils.getNoNil(tonumber(getUserAttribute(nodeId, "baleValueScale")), 1);
    self.fillType = FillType.STRAW;
    local fillTypeStr = getUserAttribute(nodeId, "fillType");
    if fillTypeStr ~= nil then
        local fillTypeIndex = g_fillTypeManager:getFillTypeIndexByName(fillTypeStr)
        if fillTypeIndex ~= nil then
            self.fillType = fillTypeIndex;
        end
    elseif Utils.getNoNil(getUserAttribute(nodeId, "isHaybale"), false) then
        self.fillType = FillType.DRYGRASS_WINDROW;
    end
    local baleWidth = tonumber(getUserAttribute(nodeId, "baleWidth"));
    local baleHeight = tonumber(getUserAttribute(nodeId, "baleHeight"));
    local baleLength = tonumber(getUserAttribute(nodeId, "baleLength"));
    local baleDiameter = tonumber(getUserAttribute(nodeId, "baleDiameter"));
    if baleDiameter ~= nil and baleWidth ~= nil then
        self.baleDiameter = baleDiameter;
        self.baleWidth = baleWidth;
    elseif baleHeight ~= nil and baleWidth ~= nil and baleLength ~= nil then
        self.baleHeight = baleHeight;
        self.baleWidth = baleWidth;
        self.baleLength = baleLength;
    else
        local isRoundbale = Utils.getNoNil(getUserAttribute(nodeId, "isRoundbale"), false);
        if isRoundbale then
            self.baleDiameter = 1.8;
            self.baleWidth = 1.2;
        else
            self.baleHeight = 0.8;
            self.baleWidth = 1.2;
            self.baleLength = 2.4;
        end
    end
end

RoundbaleFillVolume:init()





