-----------------------------------------------------
----------------Specjalizacja do Ursusa--------------
-----------------------------------------------------
-----------------------------------------------------
------------------Author: MajsteR--------------------
-----------------------------------------------------
---- Copyright 2011 MajsteR All Rights Reserved.----
-----------------------------------------------------
-------------- www.majster-mod.xaa.pl ---------------
-----------------------------------------------------
-----------------------------------------------------
--#################################################################################
Ursus1224 = {};
--#################################################################################
function Ursus1224.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;
--#################################################################################
function Ursus1224:load(xmlFile)
	
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	
	self.setHydraulicTime = 30;
	
	self.controlpath = Utils.getFilename("Scripts/pomoc.png", self.baseDirectory);
    self.URhudWidth = 0.36;
    self.URhudHeight = 0.42;
	self.URhudPoxX = -0.03;
    self.URhudPoxY = 1-0.58;
    self.URhudOverlay = Overlay:new("URhudControl", self.controlpath, self.URhudPoxX, self.URhudPoxY, self.URhudWidth, self.URhudHeight);
	
	
	
	self.halogenyP = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Halogeny#Przednie"));
	self.halogenyPActive = false; 

	self.halogenyT = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Halogeny#Tylnie"));
	self.halogenyTActive = false;

	
	self.kierunek = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Kierunki#L"));	
	self.kierunekActive = false;
	
    self.kierunek2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Kierunki#P"));	
	self.kierunek2Active = false;
	
	turn1SoundFile = Utils.getFilename("turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	turn2SoundFile = Utils.getFilename("turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);	
	
end;
--#################################################################################
function Ursus1224:keyEvent(unicode, sym, modifier, isDown)
	
	if isDown and sym == Input.KEY_0 then
		self.bcActive = not self.bcActive;
	end;

end;
--#################################################################################
function Ursus1224:update(dt)
	if self.isEntered then
		setVisibility(self.halogenyT, self.halogenyTActive);
		setVisibility(self.halogenyP, self.halogenyPActive);
		
		
		if self.flash then
			if self.delayOn >= 0 then
				self.delayOn = self.delayOn -dt;
			end;
			if not self.flashlightsRightActive then
				if self.delayOn < 0 then
					self.delayOff = 500;
					self.flashlightsRightActive = true;
					self.flashlightsLeftActive = true;
					self.flashlightsWarnerActive = true;
					self.kierunek2Active = true;
					self.kierunekActive = true;
					playSample(self.turn1, 1, 0.7, 0);
				end;
			end;
			if self.delayOff >= 0 then
				self.delayOff = self.delayOff -dt;
			end;
			if self.flashlightsRightActive then
				if self.delayOff < 0 then
					self.delayOn = 500;
					self.flashlightsLeftActive = false;
					self.flashlightsRightActive = false;
					self.flashlightsWarnerActive = false;
					self.kierunek2Active = false;
					self.kierunekActive = false;
					playSample(self.turn2, 1, 0.7, 0);
				end;
			end;
		end;
	
		if self.flashRight then
			if self.delayOnRight >= 0 then
				self.delayOnRight = self.delayOnRight -dt;
			end;
			if not self.flashlightsRightActive then
				if self.delayOnRight < 0 then
					self.delayOffRight = 500;
					self.flashlightsRightActive = true;
					self.kierunek2Active = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffRight >= 0 then
				self.delayOffRight = self.delayOffRight -dt;
			end;
			if self.flashlightsRightActive then
				if self.delayOffRight < 0 then
					self.delayOnRight = 500;
					self.flashlightsRightActive = false;
					self.kierunek2Active = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.kierunek2Active = false;
			end;
		end;
	
		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.kierunekActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.kierunekActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.kierunekActive = false;
			end;
		end;
		setVisibility(self.kierunek, self.kierunekActive);
		setVisibility(self.kierunek2, self.kierunek2Active);
	
		if InputBinding.hasEvent(InputBinding.Ursus1224_Dach) then
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, self.animationParts[1].offSet);
			elseif self.animationParts[1].clipStartTime then
				self:setAnimationTime(1, self.animationParts[1].animDuration);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.Ursus1224_TylnaSzyba) then
			if self.animationParts[2].clipEndTime then
				self:setAnimationTime(2, self.animationParts[2].offSet);
			elseif self.animationParts[2].clipStartTime then
				self:setAnimationTime(2, self.animationParts[2].animDuration);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.Ursus1224_DrzwiP) then
			if self.animationParts[3].clipEndTime then
				self:setAnimationTime(3, self.animationParts[3].offSet);
			elseif self.animationParts[3].clipStartTime then
				self:setAnimationTime(3, self.animationParts[3].animDuration);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.Ursus1224_DrzwiL) then
			if self.animationParts[4].clipEndTime then
				self:setAnimationTime(4, self.animationParts[4].offSet);
			elseif self.animationParts[4].clipStartTime then
				self:setAnimationTime(4, self.animationParts[4].animDuration);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.frontwork) then
			self.halogenyP = not self.halogenyP;
		end;
		if InputBinding.hasEvent(InputBinding.backwork) then
			self.halogenyT = not self.halogenyT;
		end;
	
	end; -- isEntered
if self:getIsActive() then			
		self.setHydraulicTime = 30;	
	end;

	if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do 
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;	
	 
end;		
--#################################################################################		
function Ursus1224:draw()
	
	if self.bcActive then
		setTextBold(true);
		setTextColor(0,1,0,1);
		renderText(0.79, 0.24, 0.022, "Klawisz 0: [I-N-F-O]");
	else
		setTextBold(true);
		setTextColor(1,0,0,1);
		renderText(0.79, 0.24, 0.022, "Klawisz 0: [I-N-F-O]");
	end;
	
	if self.URhudOverlay ~= nil then
		if self.bcActive then
			self.URhudOverlay:render();
		end;
	end;	
	
	if self.bcActive then
		if self.halogenyP then
			setTextColor(0,1,0,1);
			renderText(0.05, 0.775, 0.018, "Klawisz 5: Halogeny (P)");
		else
			setTextColor(1,0,0,1);
			renderText(0.05, 0.775, 0.018, "Klawisz 5: Halogeny (P)");
		end;
  		if self.halogenyT then
			setTextColor(0,1,0,1);
			renderText(0.05, 0.755, 0.018, "Klawisz 6: Halogeny (T)");
		else
			setTextColor(1,0,0,1);
			renderText(0.05, 0.755, 0.018, "Klawisz 6: Halogeny (T)");
		end;
		if self.kierunekL then
			setTextColor(0,1,0,1);
			renderText(0.05, 0.735, 0.018, "Klawisz KP 1: Kierunek(L)");
		else
			setTextColor(1,0,0,1);
			renderText(0.05, 0.735, 0.018, "Klawisz KP 1: Kierunek(L)");
		end;
		if self.awaryjne then
			setTextColor(0,1,0,1);
			renderText(0.05, 0.715, 0.018, "Klawisz KP 2: Awaryjne");
		else
			setTextColor(1,0,0,1);
			renderText(0.05, 0.715, 0.018, "Klawisz KP 2: Awaryjne");
		end;
		if self.kierunekP then
			setTextColor(0,1,0,1);
			renderText(0.05, 0.695, 0.018, "Klawisz KP 3: Kierunek(P)");
		else
			setTextColor(1,0,0,1);
			renderText(0.05, 0.695, 0.018, "Klawisz KP 3: Kierunek(P)");
		end;
		if self.animationParts[1].clipStartTime then
			setTextColor(1,0,0,1);
			renderText(0.05, 0.675, 0.018, "Klawisz 7: Dach");
		else
			setTextColor(0,1,0,1);
			renderText(0.05, 0.675, 0.018, "Klawisz 7: Dach");
		end;
		if self.animationParts[2].clipStartTime then
			setTextColor(1,0,0,1);
			renderText(0.05, 0.655, 0.018, "Klawisz 8: Tylna Szyba");
		else
			setTextColor(0,1,0,1);
			renderText(0.05, 0.655, 0.018, "Klawisz 8: Tylna Szyba");
		end;
		if self.animationParts[3].clipStartTime then
			setTextColor(1,0,0,1);
			renderText(0.05, 0.635, 0.018, "Klawisz KP 5: Drzwi Prawe");
		else
			setTextColor(0,1,0,1);
			renderText(0.05, 0.635, 0.018, "Klawisz KP 5: Drzwi Prawe");
		end;
		if self.animationParts[4].clipStartTime then
			setTextColor(1,0,0,1);
			renderText(0.05, 0.615, 0.018, "Klawisz KP 4: Drzwi Lewe");
		else
			setTextColor(0,1,0,1);
			renderText(0.05, 0.615, 0.018, "Klawisz KP 4: Drzwi Lewe");
		end;
		
	
	end;
 
	

	
	


end;
--#################################################################################
function Ursus1224:onEnter()
    
end;
--#################################################################################
function Ursus1224:onLeave()
	self.halogenTActive = false; 

end;
--#################################################################################
function Ursus1224:delete()
end;
--#################################################################################
function Ursus1224:mouseEvent(posX, posY, isDown, isUp, button)
end;
--#################################################################################
function Ursus1224:setHydraulicDirection(index)

	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;
--#################################################################################
function Ursus1224:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
