--------------------------------------------------------------------------------------
-- MOD: Switcher
-- MOD Author: edmund
-- MOD date: 8.1.2011
--
-- Copyright (C) edmund --
-- Contact via PM @ 
-- 1. http://planet-ls.de/board/index.php?page=User&userID=45283
-- 2. http://forum.landwirtschafts-simulator.de/memberlist.php?mode=viewprofile&u=9151
--------------------------------------------------------------------------------------

Switcher = {};

function Switcher:loadMap(name)
	self.aPositions = {};
	local aNameSearch = {"vehicle.name." .. g_languageShort, "vehicle.name.en", "vehicle.name", "vehicle#type"};
	self.nLocked = 0;
	
	if Steerable.load ~= nil then
		local orgSteerableLoad = Steerable.load
		
		Steerable.load = function(self,xmlFile)
			orgSteerableLoad(self,xmlFile)
			
			for nIndex,sXMLPath in pairs(aNameSearch) do 
				self.name = getXMLString(xmlFile, sXMLPath);
				if self.name ~= nil then break; end;
			end;
			if self.name == nil then self.name = g_i18n:getText("UNKNOWN") end;
		end;
	end;
	
	if Attachable.load ~= nil then
		local orgAttachableLoad = Attachable.load
		
		Attachable.load = function(self,xmlFile)
			orgAttachableLoad(self,xmlFile)
			
			for nIndex,sXMLPath in pairs(aNameSearch) do 
				self.name = getXMLString(xmlFile, sXMLPath);
				if self.name ~= nil then break; end;
			end;
			if self.name == nil then self.name = g_i18n:getText("UNKNOWN") end;
		end
	end;
end;

function Switcher:deleteMap()
end;

function Switcher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Switcher:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_s and bitAND(modifier, Input.MOD_ALT) > 0 then
		if self.nLocked < 2 then 
			self.nLocked = self.nLocked + 1;
		else
			self.nLocked = 0;
		end;
		return true;
	end;

	
	if isDown and sym >= 48 and sym <= 57 then
		nPosition = tonumber(string.char(sym));
		if nPosition == 0 then nPosition = 10 end;
		
		--on activate		
		if bitAND(modifier, Input.MOD_ALT) > 0 then 
			self:activateVehicle(nPosition); 
			Input.keyPressedState = {};
		end;
		
		--on save
		if bitAND(modifier, Input.MOD_CTRL) > 0 then 
			self:saveVehicle(nPosition); 
			Input.keyPressedState = {};
		end;
	end;
end;

function Switcher:getActiveVehicleId()
	return networkGetObjectId(g_currentMission.controlledVehicle);
end;

function Switcher:activateVehicle(nPosition)
	nActiveVehicleId = self:getActiveVehicleId();
	
	if self.aPositions[nPosition] ~= nil then
		if nActiveVehicleId ~= self.aPositions[nPosition] then
			local oVehicle = networkGetObject(self.aPositions[nPosition]);
			
			if oVehicle == nil then
				self.aPositions[nPosition] = nil;
			else
				if oVehicle.isControlled == false then
					g_client:getServerConnection():sendEvent(VehicleEnterRequestEvent:new(oVehicle, g_settingsNickname));
					return true;
				end;
			end;
		end;
	end;
	
	return false;
end;

function Switcher:saveVehicle(nPosition)
	if self.nLocked == 2 then return false; end;
	
	if g_currentMission.controlPlayer == false then
		if self.nLocked == 1 then
			if self.aPositions[nPosition] ~= nil then
				return false;
			end;
		end;
		
		self.aPositions[nPosition] = self:getActiveVehicleId();
		return true;
	end;
	
	return false;
end;

function Switcher:update(dt)
	if Input.keyPressedState[308] then
		local fPosX = 0.014;
		local fPosY = 0.78;
		local fFontSize = 0.022;
		local fLineDist = fFontSize + 0.003;
		
		setTextAlignment(RenderText.ALIGN_LEFT);
		
		local nLine = 0;
		setTextColor(1,1,1,1);
		renderText(fPosX, fPosY, fFontSize, "Switcher v2");
		
		nLine = nLine + 1;
		setTextBold(true);
		if self.nLocked == 0 then
			setTextColor(0,1,0,1);
			renderText(fPosX, fPosY-(nLine*fLineDist), fFontSize, g_i18n:getText("PROTECTION_UNLOCKED"));
		elseif self.nLocked == 1 then
			setTextColor(1,1,0,1);
			renderText(fPosX, fPosY-(nLine*fLineDist), fFontSize, g_i18n:getText("PROTECTION_PROTECTED"));
		else 
			setTextColor(1,0,0,1);
			renderText(fPosX, fPosY-(nLine*fLineDist), fFontSize, g_i18n:getText("PROTECTION_LOCKED"));
		end;
		
		setTextBold(false);
		setTextColor(1,1,1,0.95);
		local i;
		for i=1,10 do
			nLine = nLine + 1;
			local oVehicle = nil;
			
			if self.aPositions[i] ~= nil then
				local oVehicle = networkGetObject(self.aPositions[i]);
				if oVehicle == nil then self.aPositions[i] = nil; end;
			end;
			
			if self.aPositions[i] == nil then
				renderText(fPosX, fPosY-(nLine*fLineDist), fFontSize, i .. " -");
			else
				local sLineOutput = "";
				if oVehicle == nil then oVehicle = networkGetObject(self.aPositions[i]); end;
				
				
				if oVehicle.isControlled then 
					if oVehicle.controllerName ~= nil then 
						sLineOutput = sLineOutput .. " (" .. string.sub(Utils.getNoNil(oVehicle.controllerName, g_i18n:getText("UNKNOWN")), 0, 15) .. ")"; 
					end;
				end;
				
				if oVehicle.isHired then sLineOutput = sLineOutput .. " [H]" end;	
			
				sLineOutput = sLineOutput .. " " .. string.sub(oVehicle.name, 0, 50);
				
				for nIndex,oImplement in pairs(oVehicle.attachedImplements) do
					if oImplement ~= nil and oImplement.object ~= nil then
						sLineOutput = sLineOutput .. " + " .. string.sub(oImplement.object.name, 0, 50);
					end;					
				end;
				
				renderText(fPosX, fPosY-(nLine*fLineDist), fFontSize, i .. " =" .. sLineOutput);
			end;
		end;
	end;
end;

function Switcher:draw()
end;

addModEventListener(Switcher);
