--
-- Manure Mod
--
-- Author: HmcrE
-- Date:   27-04-2011
--

FruitUtil.registerFruitType("manureSolid", false, false, true, 1, 100, 2, 1, 1, nil)
FruitUtil.registerFruitType("manureLiquid", false, false, true, 1, 100, 2, 1, 1, nil)

local sprayerUpdateTickBackup = Sprayer.updateTick
local sprayerLoadBackup = Sprayer.load

Sprayer.load = function(self, xmlFile)
	sprayerLoadBackup(self, xmlFile)
	if self.fillTypes[Fillable.FILLTYPE_MANURE] then
		self.manureMod_active = true
	else
		self.manureMod_active = false
	end;

	if self.fillTypes[Fillable.FILLTYPE_KALK] then
		self.manureMod2_active = true
	else
		self.manureMod2_active = false
	end;
	
	if self.fillTypes[Fillable.FILLTYPE_LIQUIDMANURE] then
		self.manureMod1_active = true
	else
		self.manureMod1_active = false
	end;	
end;

Sprayer.updateTick = function(self, dt)
	sprayerUpdateTickBackup(self, dt)
	if self.isTurnedOn then
		if self.fillLevel > 0 and self.manureMod_active and self.currentFillType == Fillable.FILLTYPE_MANURE then
			for i = 1, table.getn(self.cuttingAreas) do
				local x, y, z = getWorldTranslation(self.cuttingAreas[i].start)
				local x1, y1, z1 = getWorldTranslation(self.cuttingAreas[i].width)
				local x2, y2, z2 = getWorldTranslation(self.cuttingAreas[i].height)
				local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_MANURESOLID, x, z, x1, z1, x2, z2);
				Utils.MANURESOLIDArea(x, z, x1, z1, x2, z2)
			end;
		end;

		if self.fillLevel > 0 and self.manureMod2_active and self.currentFillType == Fillable.FILLTYPE_KALK then
			for i = 1, table.getn(self.cuttingAreas) do
				local x, y, z = getWorldTranslation(self.cuttingAreas[i].start)
				local x1, y1, z1 = getWorldTranslation(self.cuttingAreas[i].width)
				local x2, y2, z2 = getWorldTranslation(self.cuttingAreas[i].height)
				local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_KALK, x, z, x1, z1, x2, z2);
				Utils.KALKArea(x, z, x1, z1, x2, z2)
			end;
		end;
		
		if self.fillLevel > 0 and self.manureMod1_active and self.currentFillType == Fillable.FILLTYPE_LIQUIDMANURE then
			for i = 1, table.getn(self.cuttingAreas) do
				local x, y, z = getWorldTranslation(self.cuttingAreas[i].start)
				local x1, y1, z1 = getWorldTranslation(self.cuttingAreas[i].width)
				local x2, y2, z2 = getWorldTranslation(self.cuttingAreas[i].height)
				local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_MANURELIQUID, x, z, x1, z1, x2, z2);
				Utils.MANURELIQUIDArea(x, z, x1, z1, x2, z2)
			end;
		end;
		
	end;

end;


Utils.MANURELIQUIDArea = function(x, z, x1, z1, x2, z2)
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] ~= nil then
		local cultiId = g_currentMission.cultivatorChannel;
		local sowingId = g_currentMission.sowingChannel;
		local detailId = g_currentMission.terrainDetailId;
		local ploughId = g_currentMission.ploughChannel;
		local sprayId = g_currentMission.sprayChannel;
		local dx, dz, dwidthX, dwidthZ, dheightX, dheightZ = Utils.getXZWidthAndHeight(detailId, x, z, x1, z1, x2, z2)
		setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, 0, 1, detailId, sowingId, 1, 1)
		setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, 0, 1, detailId, ploughId, 1, 1)
		setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, 0, 1, detailId, cultiId, 1, 1)
	end;
end;

Utils.MANURESOLIDArea = function(x, z, x1, z1, x2, z2)
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] ~= nil then
		local cultiId = g_currentMission.cultivatorChannel;
		local sowingId = g_currentMission.sowingChannel;
		local detailId = g_currentMission.terrainDetailId;
		local ploughId = g_currentMission.ploughChannel;
		local sprayId = g_currentMission.sprayChannel;
		local dx, dz, dwidthX, dwidthZ, dheightX, dheightZ = Utils.getXZWidthAndHeight(detailId, x, z, x1, z1, x2, z2)
		setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, 0, 1, detailId, sowingId, 1, 1)
		setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, 0, 1, detailId, ploughId, 1, 1)
		setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, 0, 1, detailId, cultiId, 1, 1)
	end;
end;

Utils.KALKArea = function(x, z, x1, z1, x2, z2)
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_KALK] ~= nil then
		local cultiId = g_currentMission.cultivatorChannel;
		local sowingId = g_currentMission.sowingChannel;
		local detailId = g_currentMission.terrainDetailId;
		local ploughId = g_currentMission.ploughChannel;
		local sprayId = g_currentMission.sprayChannel;
		local dx, dz, dwidthX, dwidthZ, dheightX, dheightZ = Utils.getXZWidthAndHeight(detailId, x, z, x1, z1, x2, z2)
		setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_KALK].windrowId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, 0, 1, detailId, sowingId, 1, 1)
		setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_KALK].windrowId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, 0, 1, detailId, ploughId, 1, 1)
		setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_KALK].windrowId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, 0, 1, detailId, cultiId, 1, 1)
	end;
end;

local utilsUpdateDestroyCommonArea = Utils.updateDestroyCommonArea;
Utils.updateDestroyCommonArea = function(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
	utilsUpdateDestroyCommonArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);

	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
	
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
    
    if g_currentMission.fruits[FruitUtil.FRUITTYPE_KALK] ~= nil then
		Utils.updateDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_KALK].windrowId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0, 0);
	end;
end;