--------------------------------------------------------------------------------------
-- MOD: Inspector
-- MOD Author: edmund
-- MOD date: 26.1.2011
--
-- Copyright (C) edmund --
-- Contact via PM @ 
-- 1. http://planet-ls.de/board/index.php?page=User&userID=45283
-- 2. http://forum.landwirtschafts-simulator.de/memberlist.php?mode=viewprofile&u=9151
--------------------------------------------------------------------------------------

Inspector = {};

function Inspector:loadMap(name)
	self.aPositions = {};
	local aNameSearch = {"vehicle.name." .. g_languageShort, "vehicle.name.en", "vehicle.name", "vehicle#type"};
	self.bDisplay = 1;
	
	if Steerable.load ~= nil then
		local orgSteerableLoad = Steerable.load
		
		Steerable.load = function(self,xmlFile)
			orgSteerableLoad(self,xmlFile)
			
			for nIndex,sXMLPath in pairs(aNameSearch) do 
				self.name = getXMLString(xmlFile, sXMLPath);
				if self.name ~= nil then break; end;
			end;
			if self.name == nil then self.name = g_i18n:getText("UNKNOWN") end;
		end;
	end;
	
	if Attachable.load ~= nil then
		local orgAttachableLoad = Attachable.load
		
		Attachable.load = function(self,xmlFile)
			orgAttachableLoad(self,xmlFile)
			
			for nIndex,sXMLPath in pairs(aNameSearch) do 
				self.name = getXMLString(xmlFile, sXMLPath);
				if self.name ~= nil then break; end;
			end;
			if self.name == nil then self.name = g_i18n:getText("UNKNOWN") end;
		end
	end;
end;

function Inspector:deleteMap()
end;

function Inspector:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Inspector:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_a and bitAND(modifier, Input.MOD_ALT) > 0 then
		if self.bDisplay == 0 then 
			self.bDisplay = 1;
		else
			self.bDisplay = 0;
		end;
	end;
end;

function Inspector:update(dt)
end;

function Inspector:draw()
	if self.bDisplay == 0 then return true; end;
	
	if Input.keyPressedState[308] then
		return true;
	else
		local fPosX = 0.014;
		local fPosY = 0.78;
		local fFontSize = 0.016;
		local fLineDist = fFontSize + 0.002;
		setTextAlignment(RenderText.ALIGN_LEFT);
		local nLine = 0;
		
		local nVehicles = table.getn(g_currentMission.steerables);
		if nVehicles > 0 then
			for i=1,nVehicles do
				local oVehicle = g_currentMission.steerables[i];
				setTextBold(false);
				setTextColor(1,1,1,1);
				
				local sLineOutput = "";
				if oVehicle.isControlled then				
					if oVehicle.controllerName ~= nil then 
						sLineOutput = sLineOutput .. " (" .. string.sub(Utils.getNoNil(oVehicle.controllerName, g_i18n:getText("UNKNOWN")), 0, 15) .. ")"; 
					end;
					
					if g_currentMission.controlledVehicle == oVehicle then
						setTextBold(true);
					end;
				end;
				
				sLineOutput = sLineOutput .. " " .. string.sub(oVehicle.name, 0, 50);
				for nIndex,oImplement in pairs(oVehicle.attachedImplements) do
					if oImplement ~= nil and oImplement.object ~= nil then
						sLineOutput = sLineOutput .. " + " .. string.sub(oImplement.object.name, 0, 50);
					end;					
				end;
				
				if oVehicle.isHired then 
					sLineOutput = sLineOutput .. " [H]";
					setTextColor(0.72,0.80,0.98,1);
				end;
				
				local bHasGrainInTank = false;
				if oVehicle.grainTankFillLevel ~= nil then
					if oVehicle.grainTankFillLevel > 0 then 
						bHasGrainInTank = true;
						local nTankPercentage = oVehicle.grainTankFillLevel / oVehicle.grainTankCapacity * 100;
						local sFruitType = FruitUtil.fruitIndexToDesc[oVehicle.currentGrainTankFruitType].name;
						
						if g_i18n:hasText(sFruitType) then
							sFruitType = g_i18n:getText(sFruitType);
						end;
						
						sLineOutput = sLineOutput .. " @" .. math.ceil(nTankPercentage - 0.5) .. "% (" .. sFruitType .. ")";
						
						if nTankPercentage > 80 then 
							setTextColor(0.98,0.76,0.43,0.9);
						end;
					end;
				end;
				
				if bHasGrainInTank or oVehicle.isControlled or oVehicle.isHired then
					nLine = nLine + 1;
					renderText(fPosX, fPosY-(nLine*fLineDist), fFontSize, sLineOutput);
				end;
			end;
		end;
	end;
end;

addModEventListener(Inspector);
