Nadstawy = {};

function Nadstawy.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Nadstawy:load(xmlFile)
	self.setToggleNadstawy = SpecializationUtil.callSpecializationsFunction("setToggleNadstawy");
    self.items1 = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.items1.item1(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        if node ~= nil then
            setVisibility(node, false);
            table.insert(self.items1, {node=node});
        end;
        i = i + 1;
    end;
    self.items1Active = false;
end;

function Nadstawy:delete()
end;

function Nadstawy:readStream(streamId, connection)
	self:setToggleNadstawy(streamReadBool(streamId), true);
end;

function Nadstawy:writeStream(streamId, connection)
	streamWriteBool(streamId, self.items1Active);
end;

function Nadstawy:readUpdateStream(streamId, timestamp, connection)
end;

function Nadstawy:writeUpdateStream(streamId, connection, dirtyMask)
end;

function Nadstawy:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Nadstawy:keyEvent(unicode, sym, modifier, isDown)
end;

function Nadstawy:update(dt)
    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.toggleNadstawy) then
            self:setToggleNadstawy(not self.items1Active);
        end;
    end;
end;

function Nadstawy:updateTick(dt)
end;

function Nadstawy:draw()
	if self.items1Active then
		g_currentMission:addHelpButtonText(g_i18n:getText("unmountNadstawy"),  InputBinding.toggleNadstawy);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("mountNadstawy"),  InputBinding.toggleNadstawy);
	end;
end;

function Nadstawy:onDetach()
end;

function Nadstawy:onLeave()
end;

function Nadstawy:onDeactivate()
end;

function Nadstawy:setIsTurnedOn(turnedOn, noEventSend)
end;

function Nadstawy:onDeactivateSounds()
end;

function Nadstawy:setToggleNadstawy(visibilityNadstawy, noEventSend)
    --if visibilityNadstawy ~= self.items1Active then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SetToggleNadstawyEvent:new(self, visibilityNadstawy), nil, nil, self);
            else
                g_client:getServerConnection():sendEvent(SetToggleNadstawyEvent:new(self, visibilityNadstawy));
            end;
        end;
        self.items1Active = visibilityNadstawy;
        for _, item1 in pairs(self.items1) do
            setVisibility(item1.node, visibilityNadstawy);
        end;
        for _,v in pairs(self.specializations) do
            if v.setitem1Visibility ~= nil then
				v.setitem1Visibility(self, visibilityNadstawy);
            end;
        end;	
    --end;
end;