--
-- Royal Bank of LS Kredit 1Mil v1.2
-- 
--
-- @author  Neelson
-- @date  	29/10/2011
--
print("royalbankoflskredit1m v1.2 loaded");
royalbankoflskredit1m = {};
royalbankoflskredit1m.kredithoehe = 1000000;
royalbankoflskredit1m.zinssatzLeicht = 8;
royalbankoflskredit1m.zinssatzNormal = 16;
royalbankoflskredit1m.zinssatzSchwer = 24;

function royalbankoflskredit1m.prerequisitesPresent(specializations)
    return true;
end;

function royalbankoflskredit1m:load(xmlFile)
	self.zinsbetrag = royalbankoflskredit1m:getCurrentZinsbetrag();
	
	if royalbankoflsdisplay.royalbankoflsdisplay.isDisplayModLoaded then
		self.isDisplayModLoaded = true;
	else
		self.isDisplayModLoaded = false;		
	end;
		
	if self.isDisplayModLoaded then
		royalbankoflsdisplay.royalbankoflsdisplay:addCreditSum(royalbankoflskredit1m.kredithoehe);
		royalbankoflsdisplay.royalbankoflsdisplay:addZinsSum(self.zinsbetrag)
	end;	
	
	self.kreditabloese = royalbankoflskredit1m.kredithoehe * ((g_currentMission.missionStats.difficulty * 0.01) + 1);
	g_currentMission:addSharedMoney(royalbankoflskredit1m.kredithoehe);
	
	self.firstRun = false;
	self.lastday = g_currentMission.environment.currentDay;	
end;

function royalbankoflskredit1m:delete()
	if self.isDisplayModLoaded then
		royalbankoflsdisplay.royalbankoflsdisplay:subCreditSum(royalbankoflskredit1m.kredithoehe);
		self.zinsbetrag = royalbankoflskredit1m:getCurrentZinsbetrag();
		royalbankoflsdisplay.royalbankoflsdisplay:subZinsSum(self.zinsbetrag);
	end;
	g_currentMission:addSharedMoney(-self.kreditabloese);
end;

function royalbankoflskredit1m:mouseEvent(posX, posY, isDown, isUp, button)
end;

function royalbankoflskredit1m:keyEvent(unicode, sym, modifier, isDown)
end;

function royalbankoflskredit1m:update(dt)
	if g_currentMission.environment.currentDay ~= self.lastday then
		self.zinsbetrag = royalbankoflskredit1m:getCurrentZinsbetrag();
		g_currentMission:addSharedMoney(-self.zinsbetrag);
		self.lastday = g_currentMission.environment.currentDay;
		if self.firstRun then
			if self.lastMoney ~= g_currentMission.missionStats.money then
				g_currentMission.missionStats.money = self.lastMoney;
			end;
			self.firstRun = false;
		end;
	end;	
end;

function royalbankoflskredit1m:draw()
	
end;

function royalbankoflskredit1m:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	g_currentMission:addSharedMoney(-royalbankoflskredit1m.kredithoehe);
	self.lastMoney = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#lastMoney"), g_currentMission.missionStats.money);
	self.firstRun = true;
		
	return BaseMission.VEHICLE_LOAD_OK;
end;

function royalbankoflskredit1m:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'lastMoney="' .. tostring(g_currentMission.missionStats.money) ..'"';	
	
	return attributes, nil;
end;

function royalbankoflskredit1m:getTimeScaleFaktor()
	local uhrzeit = (g_currentMission.environment.dayTime/60/60/1000);
	local timeScaleFaktor = 60;
	
	if (uhrzeit > 20) then
		timeScaleFaktor = 240;
	end;

	if (uhrzeit < 6) then
		timeScaleFaktor = 240;
	end;
	
	return timeScaleFaktor;
end;

function royalbankoflskredit1m:isDay()
	local uhrzeit = (g_currentMission.environment.dayTime/60/60/1000);
	local isDay = true;
	
	if (uhrzeit > 20) then
		isDay = false;
	end;

	if (uhrzeit < 6) then
		isDay = false;
	end;
	
	return isDay;
end;

function royalbankoflskredit1m:getCurrentZinsbetrag()
	local zinsatz = 1.0;
	if g_currentMission.missionStats.difficulty == 1 then
		zinsatz = (royalbankoflskredit1m.zinssatzLeicht * 0.01) + 1;
	else
		if g_currentMission.missionStats.difficulty == 2 then
			zinsatz = (royalbankoflskredit1m.zinssatzNormal * 0.01) + 1;
		else
			zinsatz = (royalbankoflskredit1m.zinssatzSchwer * 0.01) + 1;
		end;
	end;
		
	if royalbankoflskredit1m:isDay() then
		timescale = g_currentMission.environment.timeScale;
	else
		timescale = g_currentMission.environment.timeScale / 4;
	end;
	
	local zinsbetrag = (((royalbankoflskredit1m.kredithoehe * zinsatz) - royalbankoflskredit1m.kredithoehe) / timescale);
	
	return math.ceil(zinsbetrag);
end;