--
-- Specialization for Pivot Steering
-- Spezialisierung fr Knicklenkung
-- 
-- Thanks to Manuel L. for his rotomaster script
-- which i used as base!
--
-- > Copyright (C) BoneCrusherXes , 24.05.09  ---
--
-- formula used for rotation
-- x' = (x-u)*cos(beta) - (y-v)*sin(beta) + u
-- y' = (x-u)*sin(beta) + (y-v)*cos(beta) + v


Knicklenker = {}

function Knicklenker.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Knicklenker:load(xmlFile)        
	
	steeringPivotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.steeringPivot#index"));
	st_pivotX,st_pivotY,st_pivotZ = getTranslation(steeringPivotNode);

	inCamNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.cameras.camera2#index"));

end;
      
function Knicklenker:delete()    
end;

function Knicklenker:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function Knicklenker:keyEvent(unicode, sym, modifier, isDown)
end;


function Knicklenker:update(dt)
	
  for i=1, table.getn(self.wheels) do
	twx,twy,twz = getTranslation(self.wheels[i].repr);
	wrx,wry,wrz = getRotation(self.wheels[i].repr);
	wNrx,wNry,wNrz = getRotation(self.wheels[i].driveNode);

    if twz>0 and wry ~= nil then
	local twnewX = (twx-st_pivotX)*math.cos(-wry)-(twz-st_pivotZ)*math.sin(-wry)+st_pivotX-wry;
	local twnewY = st_pivotY;
	local twnewZ = (twx-st_pivotX)*math.sin(-wry)+(twz-st_pivotZ)*math.cos(-wry)+st_pivotZ;
	local twRotNodeY = twy-st_pivotY;
	setTranslation(self.wheels[i].repr, twnewX, twnewY, twnewZ);
	setTranslation(self.wheels[i].driveNode, 0, twRotNodeY, 0);
    end;

    if twz<0 and wry ~= nil then
	local twnewX2 = (twx-st_pivotX)*math.cos(wry)-(twz-st_pivotZ)*math.sin(-wry)+st_pivotX+wry;
	local twnewY2 = st_pivotY;
	local twnewZ2 = (twx-st_pivotX)*math.sin(-wry)+(twz-st_pivotZ)*math.cos(wry)+st_pivotZ;
	local twRotNodeY = twy-st_pivotY;
	setTranslation(self.wheels[i].repr, twnewX2, twnewY2, twnewZ2);
	setTranslation(self.wheels[i].driveNode, 0, twRotNodeY, 0);
    end;
	
	CNx, CNy, CNz = getTranslation(inCamNode);
	setTranslation(inCamNode, wry, CNy, CNz);

  end;
end;
	

function Knicklenker:draw()
end;