-- author: Sabzi
-- version: 2

--[[
	V1:	
		base features:
			Displays best prices for crops you have in your silo and where they are bought.
			Display is under weather info thingie. Default keybind is left-shit-t.
			Text is green if price is still going up.
			
	V2:
		better data structure for mainly myself (to ease things)
		text size now from ingame values, should help with different resolutions
		now included every shop and everything that you can possibly sell (should work with modded fruits/maps/shops no problem)
		added the train silos, trains and trailers to check if we have stuff 
			unfortunately this means if you have potatoe/etc in pallets/heaps price won't show up (for now)
		you can change position of display with left-shift-z (will add more (aiming for the 8 possible corner), but currently there is 5 option)
		also if you have sheep, wool price will be shown
	V2.1, 2.2: fixed stupid mistakes on my part
			   added proper text for filltype names, changed icon to .dds (thanks for both, Alex30rus!)
			   added remaining display positions
]]--

priceWatch = {};

addModEventListener(priceWatch);

priceWatch.fillTypeInfo = {};		-- the base data structure to store important info

priceWatch.shops = {};				-- store shops that we are interested in
priceWatch.trains = {};				-- stopre trains (only collect them once)

priceWatch.firstLoad = true;		-- only collect shops once
priceWatch.displayInfo = false;		-- should we render text?
priceWatch.dif = 0;  				-- time since last price update

priceWatch.debug = false; 			-- print shit?

-- "constants" for display position
priceWatch.NEXT_HELP = 1; priceWatch.UNDER_HELP = 2;
priceWatch.NEXT_MAP = 4; priceWatch.ABOVE_MAP = 3; 
priceWatch.NEXT_SPEED = 5; priceWatch.ABOVE_SPEED = 6; 
priceWatch.NEXT_WEATHER = 8; priceWatch.UNDER_WEATHER = 7;  

priceWatch.textPos = priceWatch.NEXT_HELP;		-- position of text

--priceWatch.limits = {0, 0, 0, 0, 0, 0};	-- not yet implemented (prices to watch for)

--[[
to add: (self notes)
	show all best crop prices with other button or same, but pressed quickly
	
	put background overlay for visibility?		
	show total amount of payment user would get for selling all the crop (suggestion by: https://www.modhoster.com/community/user/razers)
	setting for text size
	
	config screen for all fruits -> show yes/no
	config for what screens to show -> default, all best prices, silo prices, etc
	pricelimit inside main table, 3 option: no, auto config, manual config
	
	
	???: display all prices, table? wheatPosX, etc for columns, normal posY for rows (or math, like posX*WHEAT)	should? shouldn't?
	
	for later:
		when reached max (not increasing anymore (compare to prev price/plateau)) ALERT  	pricingDynamics???????, pendingPriceDrop?????
		root crop heaps/pallets later
		find good prices based on config, save/load price limits
		able to change prices to watch for within game (color selected line, if button pressed change selected line, button for +/-, should be simple)
]]--

function priceWatch:loadMap()

	print("--- Price Watch loaded ---");
	
end;

function priceWatch:keyEvent(unicode, sym, modifier, isDown)
end;

function priceWatch:mouseEvent(posX, posY, isDown, isUp, button)
end;

function priceWatch:deleteMap()
end;

function priceWatch:update(dt)
	
	if priceWatch.firstLoad then
	
		-- collect shops
		for k, v in pairs(g_currentMission.tipTriggers) do
			if v ~= nil then
				if v.isEnabled ~= nil and v.isSellingPoint ~= nil then
					if v.isEnabled and v.isSellingPoint then
						table.insert(priceWatch.shops, v);
						-- we collect every fillType that you can sell somewhere
						for fillTK, v1 in pairs(v.acceptedFillTypes) do
							priceWatch.fillTypeInfo[fillTK] = {};
							priceWatch.fillTypeInfo[fillTK].gotSome = false;
							priceWatch.fillTypeInfo[fillTK].maxPrice = 0;
							priceWatch.fillTypeInfo[fillTK].shopName = "";
							priceWatch.fillTypeInfo[fillTK].trending = false;
						end;
					end;
				end;
			end;
		end;
						
		-- save trains for later
		for k, steerable in pairs(g_currentMission.steerables) do
			if steerable ~= nil then
				if steerable.trainSystem ~= nil then
					table.insert(priceWatch.trains, steerable);
				end;
			end;
		end;
				
		if priceWatch.debug then print("First loading done."); end;
		priceWatch.firstLoad = false;
	end;

	priceWatch.dif = priceWatch.dif + dt;
	
	if priceWatch.dif >= 2000 then  -- only update prices once every 2 second
		priceWatch.dif = 0;
		
		priceWatch:getStoredFruits();
		priceWatch:getBestPrices();
		
		if priceWatch.debug then print("updating prices") end;
	end;
		
	if InputBinding.hasEvent(InputBinding.SHOW_PRICES) then	
		priceWatch.displayInfo = not priceWatch.displayInfo;
		if priceWatch.debug then print("InputBinding.hasEvent: SHOW_PRICES") end;
	end;	
	
	if InputBinding.hasEvent(InputBinding.CHANGE_POS) then	
		if priceWatch.debug then print("InputBinding.hasEvent: CHANGE_POS") end;
		
		if priceWatch.textPos == priceWatch.NEXT_WEATHER then
			priceWatch.textPos = priceWatch.NEXT_HELP
		else
			priceWatch.textPos = priceWatch.textPos + 1;
		end;
	end;

end;

function priceWatch:getBestPrices()
	local curPrice = 0;
	
	if priceWatch.debug then print("getBestPrices"); end;
	
	-- go through the list of fillTypes that sellplaces accept
	for fillT, info in pairs(priceWatch.fillTypeInfo) do
		-- if we don't have any of the particular fillType we don't care
		if info.gotSome then
			-- go through shops to get prices
			for k, shop in pairs(priceWatch.shops) do
				if shop.acceptedFillTypes[fillT] ~= nil then  -- if shop buys our shit
					curPrice = shop:getEffectiveFillTypePrice(fillT);
					
					-- if the shop offers more price than the currently stored price, refresh info
					if curPrice > info.maxPrice then
						info.maxPrice = curPrice;
						if shop.mapHotspot ~= nil then
							if shop.mapHotspot.fullViewName ~= nil then
								info.shopName = shop.mapHotspot.fullViewName;
							end;
						end;
						if shop.pricingDynamics ~= nil then
							if shop.pricingDynamics[fillT] ~= nil then
								info.trending = shop.pricingDynamics[fillT]:getBaseCurveTrend() == PricingDynamics.TREND_CLIMBING;
							end;
						end;
					end;
				end;
			end;
		end;
	end;
	
	if priceWatch.debug then print("Got best prices."); end;
end;

-- fill gotSome in the data
function priceWatch:getStoredFruits()
	local fillInfo = {};
	
	if priceWatch.debug then print("getStoredFruits"); end;
	
	-- Reset if we have stuff or not, so we don't display prices when we sold the beans ages ago.
	for fillT, infos in pairs(priceWatch.fillTypeInfo) do
		infos.gotSome = false;
		infos.maxPrice = 0;
	end;
	
	-- check silos
	for k, silo in pairs(g_currentMission.siloTriggers) do
		if silo ~= nil then
			for k, fillType in pairs(silo.fillTypes) do
				if silo.getFillLevel ~= nil then
					if silo:getFillLevel(fillType) > 0 then
						if priceWatch.fillTypeInfo[fillType] ~= nil then   -- modded silos or whatnot can screw this
							priceWatch.fillTypeInfo[fillType].gotSome = true;
						end;
					end;
				end;
			end;
		end;
	end;
	
	if priceWatch.debug then print("Silos checked."); end;
	
	-- check trailers
	for k, attachable in pairs(g_currentMission.attachables) do
		if attachable ~= nil then
			if attachable.typeDesc == "tipper" then
				if attachable.getFillLevelInformation ~= nil then
					attachable:getFillLevelInformation(fillInfo);
					if fillInfo ~= nil then
						for i, container in pairs(fillInfo) do
							if container.fillLevel > 0 then
								if priceWatch.fillTypeInfo[container.fillType] ~= nil then -- fuel traler or something can interfere
									priceWatch.fillTypeInfo[container.fillType].gotSome = true;
								end;
							end;
						end;
					end;
				end;
			end;
		end;
	end;
	
	if priceWatch.debug then print("Trailers checked."); end;
		
	-- check trains
	fillInfo = {};
	for k, train in pairs(priceWatch.trains) do
		if train.getFillLevelInformation ~= nil then
			train:getFillLevelInformation(fillInfo);
			if fillInfo ~= nil then
				for k, info in pairs(fillInfo) do
					if info.fillLevel > 0 then
						if priceWatch.fillTypeInfo[info.fillType] ~= nil then 		-- I dunno, maybe you put something crazy in your trian, bad boy/girl!
							priceWatch.fillTypeInfo[info.fillType].gotSome = true;
						end;
					end;
				end;
			end;
		end;
	end;
	
	if priceWatch.debug then print("Trains checked."); end;
	
	-- check animals ... well sheep, I thought you have to sell milk, but turns out you don't (I should get into cow business)
	if g_currentMission.husbandries.sheep.totalNumAnimals > 0 then
		priceWatch.fillTypeInfo[FillUtil.FILLTYPE_WOOL].gotSome = true;
	end;
end;

-- figure out the display position
function priceWatch:getTextPos(lineDist, lineLength, fontSize, lineCount)

	local posX;
	local posY;
	
	if priceWatch.textPos == priceWatch.NEXT_HELP then
		posX = g_currentMission.helpBoxWidth + 0.03;
		posY = 0.98;
	elseif priceWatch.textPos == priceWatch.UNDER_HELP then
		posX = 0.03;
		if g_currentMission.missionInfo.showHelpMenu then
			--posY = 1 - g_currentMission.helpBoxContentOverlay.y - 0.03;
			posY = g_currentMission.helpBoxContentOverlay.y - 0.03;
		else
			posY = 0.98;
		end;
		
	elseif priceWatch.textPos == priceWatch.UNDER_WEATHER then
		posX = g_currentMission.weatherForecastBgOverlay.x;
		posY = g_currentMission.weatherForecastBgOverlay.y - 0.03;	
		
	elseif priceWatch.textPos == priceWatch.NEXT_WEATHER then
		posX = g_currentMission.weatherForecastBgOverlay.x - lineLength*(fontSize/3.5);
		posY = 0.98;
		
	elseif priceWatch.textPos == priceWatch.ABOVE_MAP then
		posX = 0.02;
		posY = g_currentMission.ingameMap.minMapHeight + lineCount*lineDist + 0.03;		
		
	elseif priceWatch.textPos == priceWatch.NEXT_MAP then
		posX = g_currentMission.ingameMap.minMapWidth + 0.03;
		posY = lineCount*lineDist + 0.03;
		
	elseif priceWatch.textPos == priceWatch.ABOVE_SPEED then
		posX = g_currentMission.vehicleSpeedBg.x;
		posY = g_currentMission.fuelLevelIconOverlay.y + lineCount*lineDist + 0.03;
		
	elseif priceWatch.textPos == priceWatch.NEXT_SPEED then
		posX = g_currentMission.vehicleSpeedBg.x - lineLength*(fontSize/3.5);
		posY = lineCount*lineDist + 0.03;
	end;
	return posX, posY;
end;

function priceWatch:draw()
	
	--local fontSize = 0.017; 							
	local fontSize = g_currentMission.moneyTextSize;	-- Font size, alternative: g_currentMission.inGameMessage.titleTextSize
	local lineDist = fontSize + 0.002;  				-- Distance between lines
	local posX, posY; 									-- Horizontal and vertical starting position
	local outLine;										-- What we display
	local maxLength = 0;								-- Length of longest line
	local lineCount = 0;								-- Number of lines we display
		
	--showBestPrices();  			-- base function
	--showAllPrices();   			-- displays all market prices
	--showTrendingPrices();			-- displays the prices that are going up
	--futurePrices();				-- pricingDynamics???	pendingPriceDrop??
		
	if priceWatch.displayInfo then
		setTextBold(false);	
		setTextAlignment(RenderText.ALIGN_LEFT);
		
		if priceWatch.debug then print("Displaying ..."); end;
		
		-- get max lenght for line, and lineCount
		for fillT, info in pairs(priceWatch.fillTypeInfo) do
			if info.gotSome then
				outLine = g_i18n:getText(FillUtil.fillTypeIntToName[fillT]) .. " : " .. math.floor(info.maxPrice*1000) .. " at " .. info.shopName;	
			
				if string.len(outLine) > maxLength then
					maxLength = string.len(outLine);
				end;				
				
				lineCount = lineCount + 1;
			end;
		end;
		
		posX, posY =  priceWatch:getTextPos(lineDist, maxLength, fontSize, lineCount);
		
		-- same as in update, but now we render
		for fillT, info in pairs(priceWatch.fillTypeInfo) do
			if info.gotSome then
				if info.trending then setTextColor(0, 1, 0, 1); else setTextColor(1, 1, 1, 1); end; -- set color green if price is climbing
				
				outLine = g_i18n:getText(FillUtil.fillTypeIntToName[fillT]) .. " : " .. math.floor(info.maxPrice*1000) .. " at " .. info.shopName;		
								
				renderText(posX, posY, fontSize, outLine);
				posY = posY - lineDist;
			end;
		end;		
	end;
	
end;